import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 10))

# Define colors
clear_color = 'lightgreen'
occupied_color = 'lightcoral'
robot1_color = 'white'
robot2_color = 'black'

# Define tile positions and statuses
tiles = [
    {'id': 'tile_0-1', 'pos': (0, 4), 'status': 'clear'},
    {'id': 'tile_0-2', 'pos': (1, 4), 'status': 'clear'},
    {'id': 'tile_0-3', 'pos': (2, 4), 'status': 'clear'},
    {'id': 'tile_0-4', 'pos': (3, 4), 'status': 'clear'},
    {'id': 'tile_1-1', 'pos': (0, 3), 'status': 'occupied'},
    {'id': 'tile_1-2', 'pos': (1, 3), 'status': 'occupied'},
    {'id': 'tile_1-3', 'pos': (2, 3), 'status': 'clear'},
    {'id': 'tile_1-4', 'pos': (3, 3), 'status': 'clear'},
    {'id': 'tile_2-1', 'pos': (0, 2), 'status': 'clear'},
    {'id': 'tile_2-2', 'pos': (1, 2), 'status': 'clear'},
    {'id': 'tile_2-3', 'pos': (2, 2), 'status': 'clear'},
    {'id': 'tile_2-4', 'pos': (3, 2), 'status': 'clear'},
    {'id': 'tile_3-1', 'pos': (0, 1), 'status': 'clear'},
    {'id': 'tile_3-2', 'pos': (1, 1), 'status': 'clear'},
    {'id': 'tile_3-3', 'pos': (2, 1), 'status': 'clear'},
    {'id': 'tile_3-4', 'pos': (3, 1), 'status': 'clear'},
    {'id': 'tile_4-1', 'pos': (0, 0), 'status': 'clear'},
    {'id': 'tile_4-2', 'pos': (1, 0), 'status': 'clear'},
    {'id': 'tile_4-3', 'pos': (2, 0), 'status': 'clear'},
    {'id': 'tile_4-4', 'pos': (3, 0), 'status': 'clear'},
]

# Define robot positions and colors
robots = [
    {'id': 'robot1', 'pos': (0, 3), 'color': robot1_color},
    {'id': 'robot2', 'pos': (1, 3), 'color': robot2_color},
]

# Plot tiles
for tile in tiles:
    color = clear_color if tile['status'] == 'clear' else occupied_color
    ax.add_patch(patches.Rectangle(tile['pos'], 1, 1, edgecolor='black', facecolor=color))
    ax.text(tile['pos'][0] + 0.5, tile['pos'][1] + 0.5, tile['id'], 
            color='black', ha='center', va='center', fontsize=8)

# Plot robots
for robot in robots:
    ax.add_patch(patches.Circle((robot['pos'][0] + 0.5, robot['pos'][1] + 0.5), 0.3, color=robot['color'], edgecolor='black'))
    ax.text(robot['pos'][0] + 0.5, robot['pos'][1] + 0.1, robot['id'], 
            color='black', ha='center', va='bottom', fontsize=8, bbox=dict(facecolor='white', edgecolor='none', pad=0.5))

# Add legend
legend_labels = ['Clear Tile', 'Occupied Tile', 'Robot1 (White)', 'Robot2 (Black)']
legend_colors = [clear_color, occupied_color, robot1_color, robot2_color]
for i, (label, color) in enumerate(zip(legend_labels, legend_colors)):
    ax.add_patch(patches.Rectangle((4.5, 3.5 - i), 0.4, 0.4, facecolor=color, edgecolor='black'))
    ax.text(5, 3.7 - i, label, fontsize=10, verticalalignment='center')

# Set limits and aspect
ax.set_xlim(-0.5, 5.5)
ax.set_ylim(-0.5, 4.5)
ax.set_aspect('equal')
ax.axis('off')

# Save the figure
plt.savefig('tiles/one_shot/ini_diagram_code/attempts/attempt_14.png', bbox_inches='tight')
plt.show()
# VERIFICATION FAILED:
# The legend overlaps with the grid, and the labels inside the tiles are not clearly visible.
